/* - StepperAttachListener -
 * populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class StepperAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JComboBox motorCmb;
    private JTextField velTxt;
    private JTextField accelTxt;
    private JTextField posTxt;
    private JTextField targetPosTxt;
    private JTextField torqueTxt;
    private JTextField currentTxt;
    private JSlider velScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider torqueScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel16;
    private int targetPosArray[];
    
    /** Creates a new instance of StepperAttachListener */
    public StepperAttachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numMotorsTxt, JTextField numInTxt, JComboBox motorCmb,
            JTextField velTxt, JTextField accelTxt, JTextField posTxt,
            JTextField targetPosTxt, JTextField torqueTxt, JTextField currentTxt,
            JSlider velScrl, JSlider accelScrl, JSlider targetPosScrl,
            JSlider torqueScrl, JCheckBox inputArray[], JLabel jLabel11,
            JLabel jLabel12, JLabel jLabel16, int targetPosArray[])
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.motorCmb = motorCmb;
        this.velTxt = velTxt;
        this.accelTxt = accelTxt;
        this.posTxt = posTxt;
        this.targetPosTxt = targetPosTxt;
        this.torqueTxt = torqueTxt;
        this.currentTxt = currentTxt;
        this.velScrl = velScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.torqueScrl = torqueScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel16 = jLabel16;
        this.targetPosArray = targetPosArray;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            StepperPhidget attached = (StepperPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            
            targetPosArray = new int[attached.getMotorCount()];
            
            int i;
            for(i = 0; i < attached.getMotorCount(); i++)
            {
                motorCmb.addItem(new Integer(i));
                targetPosArray[i] = 0;
                attached.setMaxVelocity(i, 0.0);
                attached.setAcceleration(i, 0.0);
                attached.setPosition(i, 0);
            }
            
            motorCmb.setSelectedIndex(0);
            
            velScrl.setValue(0);
            accelScrl.setValue(0);
            targetPosScrl.setValue(0);
            
            
            targetPosTxt.setText(Integer.toString(targetPosScrl.getValue()));
            
            //Only a Bipolar stepper has access to these features
            if(attached.getDeviceName().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
            {
                
                numInTxt.setText(Integer.toString(attached.getInputCount()));
                
                for(i = 0; i < attached.getMotorCount(); i++)
                {
                    attached.setTorque(i, 0.0);
                }
                
                torqueScrl.setValue(0);
                jLabel16.setVisible(true);
                torqueScrl.setVisible(true);
                
                
                torqueTxt.setText(Integer.toString(torqueScrl.getValue()));
                jLabel11.setVisible(true);
                torqueTxt.setVisible(true);
                
                jLabel12.setVisible(true);
                currentTxt.setVisible(true);
                
                motorCmb.setEnabled(true);
                
                for(i = 0; i < attached.getInputCount(); i++)
                {
                    inputArray[i].setVisible(true);
                }
                
                velScrl.setMaximum((int)attached.getVelocityMax(0));
                velScrl.setMinimum((int)attached.getVelocityMin(0));
                
                accelScrl.setMaximum((int)attached.getAccelerationMax(0));
                accelScrl.setMinimum((int)attached.getAccelerationMin(0));
                
                //Have arbitrarily chosen a range of -20000 - 20000, but the maximum range is closer to +-549000000000
                targetPosScrl.setMaximum((int)attached.getPositionMax(0));
                targetPosScrl.setMinimum((int)attached.getPositionMin(0));
                
                // Range for the torque is 0 - 100
                torqueScrl.setMaximum(100);
                torqueScrl.setMinimum(0);
                
                velScrl.setEnabled(true);
                accelScrl.setEnabled(true);
                targetPosScrl.setEnabled(true);
                torqueScrl.setEnabled(true);
            }
            else
            {
                numInTxt.setText("0");
                
                torqueScrl.setValue(0);
                jLabel16.setVisible(false);
                torqueScrl.setVisible(false);
                
                torqueTxt.setText("");
                jLabel11.setVisible(false);
                torqueTxt.setVisible(false);
                
                jLabel12.setVisible(false);
                currentTxt.setVisible(false);
                
                motorCmb.setEnabled(true);
                
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
                
                velScrl.setMaximum((int)attached.getVelocityMax(0));
                velScrl.setMinimum((int)attached.getVelocityMin(0));
                
                accelScrl.setMaximum((int)attached.getAccelerationMax(0));
                accelScrl.setMinimum((int)attached.getAccelerationMin(0));
                
                //Have arbitrarily chosen a range of -20000 - 20000, but the maximum range is closer to +-549000000000
                targetPosScrl.setMaximum((int)attached.getPositionMax(0));
                targetPosScrl.setMinimum((int)attached.getPositionMin(0));
                
                velScrl.setEnabled(true);
                accelScrl.setEnabled(true);
                targetPosScrl.setEnabled(true);
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
